//=============================================================================
// MenuPetStats
//=============================================================================
class SummonCatalogueWindow expands MenuUIWindow;

var MSFunServerMutator Mutator;

var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var TileWindow                winTile;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

function CreatePackageTileWindow()
{
        winTile = CreateScrollTileWindow(18, 4, 128, 248);
	winTile.SetMinorSpacing(0);
	winTile.SetMargins(0,0);
	winTile.SetOrder(ORDER_Down);
        winTile.SetSensitivity(TRUE);
}

function TileWindow CreateScrollTileWindow(
	int posX, int posY,
	int sizeX, int sizeY)
{
	local TileWindow tileWindow;
	local PersonaScrollAreaWindow winScroll;

	winScroll = PersonaScrollAreaWindow(winClient.NewChild(Class'PersonaScrollAreaWindow'));
	winScroll.SetPos(posX, posY);
	winScroll.SetSize(sizeX, sizeY);

	tileWindow   = CreateTileWindow(winScroll.clipWindow);

	return tileWindow;
}


function TileWindow CreateTileWindow(Window parent)
{
	local TileWindow tileWindow;

	// Create Tile Window inside the scroll window
	tileWindow = TileWindow(parent.NewChild(Class'TileWindow'));
	tileWindow.SetFont(Font'FontMenuSmall');
	tileWindow.SetOrder(ORDER_Down);
	tileWindow.SetChildAlignments(HALIGN_Full, VALIGN_Top);
	tileWindow.MakeWidthsEqual(False);
	tileWindow.MakeHeightsEqual(False);

	return tileWindow;
}

function CreateSummonList()
{
	local PackageTileWindow I;
	local Texture TempTex;

	for (i=0; i<32; i++)
	{
		if (Mutator.GetPackage(i, TempTex) != "")
		{
		 I = PackageTileWindow(winTile.NewChild(Class'PackageTileWindow'));
		 I.SetPackageName(Mutator.GetPackage(i));
		 I.SetPackageTexture(TempTex);
		}
	}

}

event InitWindow()
{
 local int j;
 local class<Inventory> TempItem;
 
	Super.InitWindow();
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreatePackageTileWindow();
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:
			root.PopWindow();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	if (buttonPressed.Isa('PackageTileWindow'))
	{
		CreatePackageLIst(buttonPressed.PackageName);
		ResetList();
	}

	return bHandled;
}

function CreatePackageList(String PackageName)
{
	local SummonPackageWindow newWB;
	
	newWB = SummonPackageWindow(root.InvokeMenuScreen(Class'SummonPackageWindow'));
	
	if (newWB != None)
	{
		newWB.PackageName = PackageName;
		newWB.Mutator = Mutator;
		
		newWB.UpdateInfo();
		
		newWB.Last = Self;
		Show(False);
	}
}

     /*clientTextures(1)=Texture'DeusExUI.UserInterface.SkillsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.SkillsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.SkillsBackground_4'
     clientTextures(4)=Texture'DeusExUI.UserInterface.SkillsBackground_5'
     clientTextures(5)=Texture'DeusExUI.UserInterface.SkillsBackground_6'

     ClientWidth=604
     ClientHeight=361*/

defaultproperties
{
     Title="Summonable Items"
     exitButtonText="Done"
     ClientWidth=384
     ClientHeight=256

     clientTextures(0)=Texture'PackageWindow384a'
     clientTextures(1)=Texture'PackageWindow384b'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=3
}
